from tkinter import *
import datetime

months = ["01","02","03","04","05","06","07","08","09","10","11","12"]
days = ["01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","28","29","30","31"] 
students = []

class GUI():	
	def __init__(self,root):
		root.title("Student Register")

		labelName = Label(root,text="Student Name:")
		labelName.grid(column=1,row=1)
		studentName = Entry(root)
		studentName.grid(column=2,row=1)
	
		labelAge = Label(root,text="Student Age:")
		labelAge.grid(column=1,row=2)
		studentAge = Entry(root)
		studentAge.grid(column=2,row=2)
	
		labelDOB = Label(root,text="Please enter date of birth below (dd/mm/yyyy):")
		labelDOB.grid(column=2,row=3)

		d = StringVar(root)
		d.set(days[0])
		day = OptionMenu(root,d,*days)
		day.grid(column=1,row=4)

		m = StringVar(root)
		m.set(months[0])
		month = OptionMenu(root,m,*months)
		month.grid(column=2,row=4)

		y = StringVar(root)
		year = Entry(root,text=y)
		year.grid(column=3,row=4)

		button = Button(root, text="Add Student", command= lambda: Student.addStudent(studentName.get(),studentAge.get(),d.get(),m.get(),y.get()))
		button.grid(column=2,row=5)

		button = Button(root, text="Print Students", command= lambda: Student.printStudents())
		button.grid(column=2,row=6)

class Student():
	name=""
	age=0
	dateOfBirth=""
	
	def __init__(self,name,age,dateOfBirth):
		self.name = name
		self.age = age
		self.dateOfBirth = dateOfBirth
		
	def addStudent(name,age,d,m,y):
		if(name!="" and age!="" and validate(d,m,y)):
			dateOfBirth=d+"-"+m+"-"+y
			s = Student(name,age,dateOfBirth)
			students.append(s)
			print("student successfully added")

	def printStudents():
		for s in students:
			print(s.name,s.age,s.dateOfBirth)

def validate(d,m,y):
	date_string = d+"-"+m+"-"+y
	date_format = '%d-%m-%Y'
	Result = True
	try:
		date_obj = datetime.datetime.strptime(date_string, date_format)
	except ValueError:
		Result = False
		print("Date of birth is not valid")
	return Result
						
def main():
	root = Tk()
	gui = GUI(root)
	root.mainloop()

if __name__ == '__main__':
	main()	



	
